/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.integrator;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWException;
import filenet.vw.api.VWQueue;
import filenet.vw.api.VWQueueDefinition;
import filenet.vw.api.VWSession;
import filenet.vw.apps.taskman.VWTaskActionCommand;
import filenet.vw.apps.taskman.VWTaskNumericProperty;
import filenet.vw.apps.taskman.VWTaskPropertyChangedEvent;
import filenet.vw.apps.taskman.VWTaskPropertyPanel;
import filenet.vw.apps.taskman.VWTaskTabPanel;
import filenet.vw.apps.taskman.VWTaskTabbedPane;
import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.apps.taskman.integrator.VWAdaptorsCredentialPanel;
import filenet.vw.apps.taskman.integrator.VWCMAdminNode;
import filenet.vw.apps.taskman.integrator.VWJavaSecurityPanel;
import filenet.vw.apps.taskman.integrator.VWManagerNode;
import filenet.vw.apps.taskman.integrator.VWManagerUtil;
import filenet.vw.apps.taskman.integrator.VWRequiredLibraryPanel;
import filenet.vw.apps.taskman.integrator.VWWSJSSEPanel;
import filenet.vw.apps.taskman.integrator.VWWSPanel;
import filenet.vw.apps.taskman.integrator.VWWSRMPanel;
import filenet.vw.apps.taskman.integrator.VWWSWPSAdvancedPanel;
import filenet.vw.apps.taskman.integrator.resources.VWResource;
import filenet.vw.base.VWAuthItem;
import filenet.vw.base.VWDebug;
import filenet.vw.sysutils.OperatingSystem;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.ws.listener.utils.WSListenerProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;

public class VWManagerPropertyPanel
extends VWTaskPropertyPanel {
    private static final boolean REQUIRED = true;
    private static final boolean NOT_REQUIRED = false;
    VWManagerNode m_node = null;
    VWTaskTabbedPane m_tabbedPane = null;
    VWManagerUtil m_util = new VWManagerUtil(0);
    VWRequiredLibraryPanel m_libraryPanel = null;
    VWWSJSSEPanel m_WSJSSEPanel = null;
    VWWSRMPanel m_WSRMPanel = null;
    VWWSPanel m_WSPanel = null;
    VWJavaSecurityPanel m_javaSecurityPanel = null;
    VWWSWPSAdvancedPanel m_wpsPanel = null;
    VWAdaptorsCredentialPanel m_adaptorsPanel = null;
    JLabel m_iconLabel = null;
    VWTaskNumericProperty m_registryPort = null;
    VWTaskNumericProperty m_eventPort = null;
    JTextField m_ceURI = null;
    JTextField m_connectionPoint = null;
    JTextField m_userName = null;
    JPasswordField m_password = null;
    JTextField m_JNDIContext = null;
    JTextField m_prefJREBinPath = null;
    JTextArea m_JREParameters = null;
    JTextField m_Queues = null;
    JButton m_showQueueNames = new JButton(VWResource.ShowQueueNames);
    JButton m_browseJREPath = new JButton(VWResource.Browse);
    private JFileChooser m_chooser = null;
    protected static boolean AdvancedMode = false;
    private static String[] wslistenerPropertyNames;

    public VWManagerPropertyPanel(VWManagerNode managerNode) {
        this.setDoubleBuffered(true);
        this.setLayout(new BorderLayout());
        this.m_node = managerNode;
        this.addTabbedPane();
        this.refresh(true);
        this.updateWSListenerProperties();
        this.m_tabbedPane.addVWTaskPropertyChangedListener(this);
    }

    public void refresh(boolean fullRefresh) {
        if (fullRefresh) {
            this.resetProperties();
        }
        boolean stopped = !this.m_node.isStarted();
        this.m_iconLabel.setIcon(this.m_node.getIcon32());
        this.m_ceURI.setEditable(stopped);
        this.m_connectionPoint.setEditable(stopped);
        this.m_userName.setEditable(stopped);
        this.m_password.setEditable(stopped);
        this.m_libraryPanel.updateState();
        if (this.m_WSPanel != null) {
            this.m_WSPanel.updateState(stopped);
        }
        if (this.m_WSJSSEPanel != null) {
            this.m_WSJSSEPanel.updateState(stopped);
        }
        if (this.m_WSRMPanel != null) {
            this.m_WSRMPanel.updateState(stopped);
        }
        if (this.m_wpsPanel != null) {
            this.m_wpsPanel.updateState();
        }
        if (this.m_adaptorsPanel != null) {
            this.m_adaptorsPanel.updateState();
        }
        this.m_JNDIContext.setEditable(stopped);
        this.m_registryPort.setEditable(stopped);
        this.m_eventPort.setEditable(stopped);
        this.m_prefJREBinPath.setEditable(stopped);
        this.m_JREParameters.setEditable(stopped);
        this.m_browseJREPath.setEnabled(stopped);
        this.m_Queues.setEditable(stopped);
        this.m_javaSecurityPanel.updateState(stopped);
    }

    public void applyProperties() throws Exception {
        this.m_node.setCEURI(this.m_ceURI.getText().trim());
        this.m_ceURI.setText(this.m_node.getCEURI());
        this.m_node.setConnectionPoint(this.m_connectionPoint.getText().trim());
        try {
            this.m_node.setOptions(this.m_util.getEString(this.m_userName.getText().trim(), new String(this.m_password.getPassword())));
        }
        catch (Exception e) {
            VWDebug.logException(e, "Error applying user name password.");
        }
        this.m_node.setLibraries(this.m_libraryPanel.getLibraries());
        if (this.m_node.getWSListenerProperties() != null) {
            this.m_WSPanel.applyProperties();
            this.m_WSJSSEPanel.applyProperties();
            this.m_WSRMPanel.applyProperties();
            this.m_wpsPanel.applyProperties();
            this.updateWSListenerProperties();
        }
        if (this.m_adaptorsPanel != null) {
            this.m_adaptorsPanel.applyProperties();
        }
        this.m_node.setJNDIContext(this.m_JNDIContext.getText().trim());
        this.m_node.setRegistryPort(Integer.parseInt(this.m_registryPort.getText().trim()));
        this.m_node.setEventPort(Integer.parseInt(this.m_eventPort.getText().trim()));
        this.m_node.setPreferredJREBinPath(this.m_prefJREBinPath.getText().trim());
        this.m_node.setJREParameters(this.m_JREParameters.getText().trim());
        this.m_JREParameters.setText(this.m_node.getJREParameters());
        this.m_node.setQueues(this.m_Queues.getText().trim());
        if (this.m_adaptorsPanel != null) {
            this.m_adaptorsPanel.getListFromFile();
        }
        this.m_javaSecurityPanel.applyProperties();
        this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, 1));
    }

    public void resetProperties() {
        this.m_ceURI.setText(this.m_node.getCEURI());
        this.m_connectionPoint.setText(this.m_node.getConnectionPoint());
        String userName = null;
        String password = null;
        try {
            VWAuthItem item = this.m_util.getDString(this.m_node.getOptions());
            if (item != null) {
                userName = item.getName();
                password = item.getPassword();
            }
        }
        catch (Exception e) {
            VWDebug.logException(e);
        }
        if (userName == null) {
            userName = "";
        } else if (userName.compareTo("\"\"") == 0) {
            userName = "";
        }
        if (password == null) {
            password = "";
        } else if (password.compareTo("\"\"") == 0) {
            password = "";
        }
        this.m_userName.setText(userName);
        this.m_password.setText(password);
        this.m_libraryPanel.setLibraries(this.m_node.getLibraries());
        if (this.m_WSPanel != null) {
            this.m_WSPanel.resetProperties();
        }
        if (this.m_WSJSSEPanel != null) {
            this.m_WSJSSEPanel.resetProperties();
        }
        if (this.m_WSRMPanel != null) {
            this.m_WSRMPanel.resetProperties();
        }
        this.m_JNDIContext.setText(this.m_node.getJNDIContext());
        this.m_registryPort.setText(Integer.toString(this.m_node.getRegistryPort()));
        this.m_eventPort.setText(Integer.toString(this.m_node.getEventPort()));
        this.m_prefJREBinPath.setText(this.m_node.getPreferredJREBinPath());
        this.m_JREParameters.setText(this.m_node.getJREParameters());
        this.m_Queues.setText(this.m_node.getQueues());
        this.m_javaSecurityPanel.resetProperties();
        this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, 2));
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.m_showQueueNames) {
            this.m_node.getTaskCore().displayInformation(this.getQueueNames());
            return;
        }
        if (event.getSource() == this.m_browseJREPath) {
            this.getJREPathFromDialog();
            return;
        }
        String actionCMD = event.getActionCommand();
        try {
            if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.APPLY) == 0 || VWStringUtils.compare(actionCMD, VWTaskActionCommand.OK) == 0) {
                if (this.validateProperties()) {
                    this.applyProperties();
                }
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.RESET) == 0 || VWStringUtils.compare(actionCMD, VWTaskActionCommand.CANCEL) == 0) {
                this.resetProperties();
            } else if (VWStringUtils.compare(actionCMD, VWTaskActionCommand.HELP) == 0) {
                this.m_tabbedPane.displayHelp();
            }
        }
        catch (Exception ex) {
            this.m_node.displayError(ex);
        }
    }

    private String getQueueNames() {
        try {
            StringBuffer buf = new StringBuffer();
            buf.append("WSRequest");
            VWSession session = new VWSession();
            session.setBootstrapCEURI(this.m_ceURI.getText());
            session.logon(this.m_userName.getText(), new String(this.m_password.getPassword()), this.m_connectionPoint.getText());
            String[] qnames = session.fetchQueueNames(1);
            VWQueue queue = null;
            VWQueueDefinition qdef = null;
            VWAttributeInfo attributes = null;
            for (int i = 0; i < qnames.length; ++i) {
                String component_descriptor;
                queue = session.getQueue(qnames[i]);
                if (queue != null) {
                    qdef = queue.fetchQueueDefinition();
                }
                if (qdef != null) {
                    attributes = qdef.getAttributeInfo();
                }
                if (attributes != null && (component_descriptor = (String)attributes.getFieldValue("F_ComponentDescriptor")) != null) {
                    buf.append(" ,").append(qnames[i]);
                }
                queue = null;
                qdef = null;
                attributes = null;
            }
            session.logoff();
            session = null;
            return buf.toString();
        }
        catch (Throwable e) {
            return VWException.DescribeThrowableAndItsCause(e);
        }
    }

    private void getJREPathFromDialog() {
        File file;
        String startingPoint;
        if (this.m_chooser == null) {
            this.m_chooser = new JFileChooser();
            this.m_chooser.setFileFilter(new FileFilter(){

                public boolean accept(File file) {
                    return file.isDirectory();
                }

                public String getDescription() {
                    return VWResource.DirectoryForJavaExe;
                }
            });
            this.m_chooser.setDialogTitle(VWResource.SelectJREBinDir);
            this.m_chooser.setFileSelectionMode(1);
            this.m_chooser.setAcceptAllFileFilterUsed(false);
        }
        if ((startingPoint = this.m_prefJREBinPath.getText()) == null || startingPoint.length() == 0) {
            startingPoint = this.m_node.getJREBinPath();
        }
        this.m_chooser.setSelectedFile(new File(startingPoint));
        int returnVal = this.m_chooser.showOpenDialog(this.m_node.getTaskCore().getMainFrame());
        if (returnVal == 0 && (file = this.m_chooser.getSelectedFile()).exists() && file.isDirectory()) {
            File javaFile;
            String javaFileName = "java";
            if (OperatingSystem.isWindows()) {
                javaFileName = "java.exe";
            }
            if ((javaFile = new File(file, javaFileName)).exists()) {
                this.m_prefJREBinPath.setText(file.getPath());
                this.taskPropertyChanged(new VWTaskPropertyChangedEvent((Object)this, null));
            } else {
                this.m_node.getTaskCore().displayError(VWResource.SelectingBinHasJavaOnly);
            }
        }
    }

    private void addTabbedPane() {
        this.m_tabbedPane = new VWTaskTabbedPane();
        VWTaskUtil.updateComponentOrientation(this.m_tabbedPane);
        this.m_tabbedPane.addTab(filenet.vw.apps.taskman.resources.VWResource.General, this.getGeneralPanel());
        this.m_tabbedPane.addTab(VWResource.RequiredLibraries, this.getLibraryPanel(), false);
        if (this.m_node.getWSListenerProperties() != null) {
            this.m_tabbedPane.addTab(VWResource.WebServices, this.getWebServicesPanel());
        }
        this.m_tabbedPane.addTab(VWResource.Advanced, this.getAdvancedPanel());
        this.m_tabbedPane.addTab(VWResource.JavaSecurity, this.getJavaSecurityPanel());
        this.m_tabbedPane.addTab(VWResource.Adaptors, this.getAdaptorsCredentialsPanel());
        this.add((Component)this.m_tabbedPane, "Center");
    }

    private void layoutLabelTextButton(VWTaskTabPanel panel, JTextComponent text, JButton button) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 23;
        gbc.insets = new Insets(5, 10, 5, 5);
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.gridwidth = 1;
        gbc.weightx = 0.0;
        panel.add((Component)new JLabel(text.getName() + ":"), gbc);
        ++gbc.gridx;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        panel.add((Component)text, gbc);
        ++gbc.gridx;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        panel.add((Component)button, gbc);
    }

    private VWTaskTabPanel getGeneralPanel() {
        VWTaskTabPanel mainPanel = new VWTaskTabPanel();
        mainPanel.setHelpPage(VWHelp.Help_Process_TaskManager + "cm_config_general.htm");
        mainPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbConst = new GridBagConstraints();
        gbConst.fill = 0;
        gbConst.anchor = 23;
        gbConst.gridwidth = 1;
        gbConst.gridheight = 1;
        gbConst.weightx = 0.0;
        gbConst.weighty = 0.0;
        gbConst.insets = new Insets(4, 10, 0, 0);
        gbConst.gridx = 0;
        gbConst.gridy = 0;
        this.m_iconLabel = new JLabel(this.m_node.getIcon32(), 2);
        mainPanel.add((Component)this.m_iconLabel, gbConst);
        gbConst.fill = 2;
        gbConst.weightx = 1.0;
        gbConst.gridy = 0;
        gbConst.gridx = 1;
        gbConst.insets = new Insets(15, 10, 0, 0);
        gbConst.gridwidth = 0;
        mainPanel.add((Component)new JLabel(VWResource.ComponentManager), gbConst);
        VWTaskTabPanel panel = new VWTaskTabPanel();
        panel.setLayout(new GridBagLayout());
        this.m_ceURI = new JTextField("");
        this.m_ceURI.setName(VWResource.ContentEngineURI);
        this.m_ceURI.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_ceURI.getName() + ":"), VWTaskPropertyPanel.LABEL_CONSTRAINTS);
        panel.add((JTextComponent)this.m_ceURI, (Object)VWTaskPropertyPanel.FIELD_CONSTRAINTS, true);
        this.m_connectionPoint = new JTextField("");
        this.m_connectionPoint.setName(VWResource.ConnectionPoint);
        this.m_connectionPoint.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_connectionPoint.getName() + ":"), LABEL_CONSTRAINTS);
        panel.add((JTextComponent)this.m_connectionPoint, (Object)FIELD_CONSTRAINTS, true);
        this.m_userName = new JTextField("");
        this.m_userName.setName(VWResource.ServiceUserName);
        this.m_userName.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_userName.getName() + ":"), LABEL_CONSTRAINTS);
        panel.add((JTextComponent)this.m_userName, (Object)FIELD_CONSTRAINTS, true);
        this.m_password = new JPasswordField("");
        this.m_password.setName(VWResource.ServicePassword);
        this.m_password.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_password.getName() + ":"), LABEL_CONSTRAINTS);
        panel.add((JTextComponent)this.m_password, (Object)FIELD_CONSTRAINTS, false);
        this.m_Queues = new JTextField("*");
        this.m_Queues.setName(VWResource.Queues);
        this.m_Queues.addFocusListener(this);
        try {
            Class.forName("filenet.vw.api.VWSession");
            this.m_showQueueNames.addActionListener(this);
            this.layoutLabelTextButton(panel, this.m_Queues, this.m_showQueueNames);
        }
        catch (Throwable e) {
            panel.add((Component)new JLabel(this.m_Queues.getName() + ":"), LABEL_CONSTRAINTS);
            panel.add((JTextComponent)this.m_Queues, (Object)FIELD_CONSTRAINTS, false);
        }
        gbConst.gridx = 0;
        gbConst.gridy = 1;
        gbConst.fill = 1;
        gbConst.gridwidth = 0;
        gbConst.weightx = 1.0;
        gbConst.weighty = 1.0;
        mainPanel.add((Component)panel, gbConst);
        VWTaskUtil.updateComponentOrientation(mainPanel);
        return mainPanel;
    }

    private VWTaskTabPanel getLibraryPanel() {
        this.m_libraryPanel = new VWRequiredLibraryPanel(this.m_node.getLibraries(), this.m_node);
        VWTaskUtil.updateComponentOrientation(this.m_libraryPanel);
        return this.m_libraryPanel;
    }

    private VWTaskTabPanel getWSPanel() {
        this.m_WSPanel = new VWWSPanel(this.m_node);
        VWTaskUtil.updateComponentOrientation(this.m_WSPanel);
        return this.m_WSPanel;
    }

    private VWTaskTabPanel getWSJSSEPanel() {
        this.m_WSJSSEPanel = new VWWSJSSEPanel(this.m_node);
        VWTaskUtil.updateComponentOrientation(this.m_WSJSSEPanel);
        return this.m_WSJSSEPanel;
    }

    private VWTaskTabPanel getAdaptorsCredentialsPanel() {
        this.m_adaptorsPanel = new VWAdaptorsCredentialPanel(this.m_node);
        VWTaskUtil.updateComponentOrientation(this.m_adaptorsPanel);
        return this.m_adaptorsPanel;
    }

    private VWTaskTabPanel getWPSPanel() {
        this.m_wpsPanel = new VWWSWPSAdvancedPanel(this.m_node);
        VWTaskUtil.updateComponentOrientation(this.m_wpsPanel);
        return this.m_wpsPanel;
    }

    private VWTaskTabPanel getWSRMPanel() {
        this.m_WSRMPanel = new VWWSRMPanel(this.m_node);
        VWTaskUtil.updateComponentOrientation(this.m_WSRMPanel);
        return this.m_WSRMPanel;
    }

    private VWTaskTabPanel getWebServicesPanel() {
        VWTaskTabPanel panel = new VWTaskTabPanel(new GridBagLayout());
        panel.setHelpPage(VWHelp.Help_Process_TaskManager + "cm_config_ws.htm");
        VWTaskTabbedPane pane = new VWTaskTabbedPane();
        VWTaskUtil.updateComponentOrientation(pane);
        pane.addTab(VWResource.WSSettings, this.getWSPanel());
        pane.addTab(VWResource.WSJSSESettings, this.getWSJSSEPanel());
        pane.addTab(VWResource.WSRMSettings, this.getWSRMPanel());
        pane.addTab(VWResource.Advanced, this.getWPSPanel());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 1;
        c.gridwidth = 1;
        c.insets = new Insets(10, 0, 0, 0);
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.add((Component)pane, c);
        return panel;
    }

    private VWTaskTabPanel getAdvancedPanel() {
        VWTaskTabPanel panel = new VWTaskTabPanel();
        panel.setHelpPage(VWHelp.Help_Process_TaskManager + "cm_config_advanced.htm");
        panel.setLayout(new GridBagLayout());
        VWTaskUtil.updateComponentOrientation(panel);
        this.m_registryPort = new VWTaskNumericProperty("");
        this.m_registryPort.setName(VWResource.RegistryPort);
        this.m_registryPort.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_registryPort.getName() + ":"), LABEL_CONSTRAINTS);
        panel.add((JTextComponent)this.m_registryPort, (Object)FIELD_CONSTRAINTS, true);
        this.m_eventPort = new VWTaskNumericProperty("");
        this.m_eventPort.setName(filenet.vw.apps.taskman.resources.VWResource.EventPort);
        this.m_eventPort.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_eventPort.getName() + ":"), LABEL_CONSTRAINTS);
        panel.add((JTextComponent)this.m_eventPort, (Object)FIELD_CONSTRAINTS, true);
        this.m_JNDIContext = new JTextField("");
        this.m_JNDIContext.addFocusListener(this);
        if (!this.m_node.getBooleanProperty("TaskManager.ComponentManager.DisableJMS")) {
            this.m_JNDIContext.setName(VWResource.JNDIInitialContextFactory);
            panel.add((Component)new JLabel(this.m_JNDIContext.getName() + ":"), LABEL_CONSTRAINTS);
            panel.add((JTextComponent)this.m_JNDIContext, (Object)FIELD_CONSTRAINTS, false);
        }
        this.m_JREParameters = new JTextArea();
        this.m_JREParameters.setRows(5);
        this.m_JREParameters.setLineWrap(true);
        this.m_JREParameters.setWrapStyleWord(true);
        this.m_JREParameters.setName(VWResource.JREParameters);
        this.m_JREParameters.addFocusListener(this);
        panel.add((Component)new JLabel(this.m_JREParameters.getName() + ":"), LABEL_CONSTRAINTS);
        panel.add((Component)new JScrollPane(this.m_JREParameters), FIELD_CONSTRAINTS);
        this.m_prefJREBinPath = new JTextField("");
        this.m_prefJREBinPath.setName(VWResource.PreferredJRE);
        this.m_prefJREBinPath.addFocusListener(this);
        this.m_browseJREPath.addActionListener(this);
        this.layoutLabelTextButton(panel, this.m_prefJREBinPath, this.m_browseJREPath);
        VWTaskUtil.updateComponentOrientation(panel);
        return panel;
    }

    private VWTaskTabPanel getJavaSecurityPanel() {
        this.m_javaSecurityPanel = new VWJavaSecurityPanel(this.m_node);
        VWTaskUtil.updateComponentOrientation(this.m_javaSecurityPanel);
        return this.m_javaSecurityPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWSListenerProperties() {
        try {
            WSListenerProperties m_listenerProps = this.m_node.getWSListenerProperties();
            if (m_listenerProps == null) {
                return;
            }
            WSListenerProperties wSListenerProperties = m_listenerProps;
            synchronized (wSListenerProperties) {
                m_listenerProps.setProperties(wslistenerPropertyNames, new String[]{this.m_ceURI.getText().trim(), this.m_connectionPoint.getText().trim(), "-1", this.m_util.getEString(this.m_userName.getText().trim(), new String(this.m_password.getPassword()))}, true);
            }
        }
        catch (Exception e) {
            VWDebug.logException(e, "Exception while updating WSListenerProperties.");
        }
    }

    private boolean validateProperties() {
        try {
            this.m_tabbedPane.validateProperties();
            if (this.m_WSRMPanel != null) {
                this.m_WSRMPanel.validateTextFields();
            }
            if (this.m_WSPanel != null) {
                this.m_WSPanel.validateTextFields();
            }
            String connectionPoint = this.m_connectionPoint.getText().trim();
            String nodeName = VWManagerNode.FormNodeName(this.m_connectionPoint.getText().trim(), this.m_Queues.getText().trim());
            VWManagerNode n = ((VWCMAdminNode)this.m_node.getParent()).getCM(nodeName);
            if (n == null || this.m_node == n) {
                return true;
            }
            throw new VWException("filenet.vw.apps.taskman.cm.VWCMAdminNode.DuplicateNames", "{0}.{1} has been defined.  Please choose a different connection point or define a different queue.", connectionPoint);
        }
        catch (VWException e) {
            this.m_node.displayError(e);
            return false;
        }
    }

    private boolean noPO() {
        if (this.m_node.getWSListenerProperties() == null) {
            return true;
        }
        String queues = this.m_Queues.getText().trim();
        return !queues.equals("*") && queues.indexOf("WSRequest") < 0;
    }

    static {
        AdvancedMode = Boolean.getBoolean("filenet.ae.taskman.cm.advanced");
        wslistenerPropertyNames = new String[]{"cm.CEURI", "cm.router", "cm.name", "cm.uid"};
    }
}

